# HazardMap Québec — Ready-to-run MVP (Mobile+Web+API+Worker)
This is a **ready-to-run** monorepo that includes:
- **Web** (Next.js) — marketing website + authenticated dashboard (Google Maps)
- **API** (FastAPI) — auth, sites, media upload (MinIO/S3), hazards, reports (JSON)
- **Worker** (Celery) — background processing + **AI stub** (includes basic snow/ice heuristic)
- **DB** (PostgreSQL + PostGIS)
- **Object storage** (MinIO) for media files

> ✅ Runs locally with Docker Compose in ~1 command.  
> ⚠️ AI detection is a functional stub meant to be replaced with real models (YOLO/segmentation/video).  
> ✅ Snow/ice detection: simple image heuristic (white-pixel ratio) + optional weather-risk flag.

---

## Quick start (local)
1) Install Docker + Docker Compose
2) In this folder:
```bash
cp .env.sample .env
# Put your Google Maps key in GOOGLE_MAPS_API_KEY
docker compose up --build
```

Then open:
- Marketing + Dashboard: http://localhost:3000
- API docs (Swagger): http://localhost:8000/docs
- MinIO console: http://localhost:9001  (user/pass in .env)

---

## Default demo account
On first run, the API auto-creates:
- Org: `Demo Org`
- Admin user: `admin@demo.local`
- Password: `admin12345`

Change this immediately for real use.

---

## What works
- Create sites + zones
- Upload photo/video (video: worker extracts one frame)
- Worker runs AI stub → creates detections → converts into hazards
- Dashboard map shows hazard pins on Google Maps
- Mark hazards FIXED / VERIFIED + add evidence links

---

## Environment variables
See `.env.sample`.

---

## Replacing the AI stub
Look at:
- `services/worker/app/inference.py` (image/video frame processing)
- `services/worker/app/rules.py` (hazard rule engine & Québec rule tags)

---

## Notes
- This project is an MVP scaffold. For production you’ll want:
  - real model inference (YOLO/segmentation/action recognition)
  - TLS, proper secrets mgmt, SSO
  - Law 25 privacy program + retention policies
  - audit trail hardening, immutability options
