from __future__ import annotations
import os, boto3

S3_ENDPOINT = os.getenv("S3_ENDPOINT", "http://minio:9000")
S3_ACCESS_KEY = os.getenv("S3_ACCESS_KEY", "minioadmin")
S3_SECRET_KEY = os.getenv("S3_SECRET_KEY", "minioadmin123")
S3_BUCKET = os.getenv("S3_BUCKET", "hazardmap-media")
S3_REGION = os.getenv("S3_REGION", "us-east-1")

def client():
    return boto3.client(
        "s3",
        endpoint_url=S3_ENDPOINT,
        aws_access_key_id=S3_ACCESS_KEY,
        aws_secret_access_key=S3_SECRET_KEY,
        region_name=S3_REGION,
    )

def ensure_bucket():
    c = client()
    try:
        c.head_bucket(Bucket=S3_BUCKET)
    except Exception:
        c.create_bucket(Bucket=S3_BUCKET)

def presign_put(key: str, content_type: str, expires=3600) -> str:
    c = client()
    return c.generate_presigned_url(
        "put_object",
        Params={"Bucket": S3_BUCKET, "Key": key, "ContentType": content_type},
        ExpiresIn=expires,
    )

def presign_get(key: str, expires=3600) -> str:
    c = client()
    return c.generate_presigned_url(
        "get_object",
        Params={"Bucket": S3_BUCKET, "Key": key},
        ExpiresIn=expires,
    )
