from __future__ import annotations
from pydantic import BaseModel, Field
from typing import Optional, List, Any

class TokenOut(BaseModel):
    access_token: str
    token_type: str = "bearer"

class LoginIn(BaseModel):
    email: str
    password: str

class SiteCreate(BaseModel):
    name: str
    address: Optional[str] = None
    centroid_lat: Optional[float] = None
    centroid_lng: Optional[float] = None

class SiteOut(BaseModel):
    id: str
    name: str
    address: Optional[str] = None
    centroid: Optional[dict] = None

class ZoneCreate(BaseModel):
    name: str
    polygon: dict  # GeoJSON Polygon

class ZoneOut(BaseModel):
    id: str
    name: str
    polygon: dict

class MediaCreate(BaseModel):
    site_id: str
    media_type: str  # PHOTO/VIDEO/DRONE_VIDEO
    filename: str
    content_type: str
    captured_at: Optional[str] = None
    gps_lat: Optional[float] = None
    gps_lng: Optional[float] = None
    heading: Optional[float] = None
    altitude: Optional[float] = None
    device_meta: dict = Field(default_factory=dict)
    blur_faces: bool = True

class MediaOut(BaseModel):
    id: str
    upload_url: str = ""
    s3_key: str

class FinalizeIn(BaseModel):
    blur_faces: bool = True

class HazardOut(BaseModel):
    id: str
    status: str
    hazard_type: str
    title: str
    severity: str
    pin: dict
    primary_rule_tags: list

class HazardPatch(BaseModel):
    status: Optional[str] = None
    assignee_id: Optional[str] = None
    title: Optional[str] = None
    description: Optional[str] = None
    pin_lat: Optional[float] = None
    pin_lng: Optional[float] = None

class DetectionOut(BaseModel):
    id: str
    hazard_signal: str
    confidence: float
    severity: str
    rule_tags: list
    frame_time_ms: Optional[int] = None
