from __future__ import annotations
import os, shutil
from pathlib import Path

MEDIA_ROOT = os.getenv("MEDIA_ROOT", "/data/media")

def ensure_media_root():
    Path(MEDIA_ROOT).mkdir(parents=True, exist_ok=True)

def site_media_dir(org_id: str, site_id: str, media_id: str) -> str:
    return str(Path(MEDIA_ROOT) / org_id / site_id / media_id)
