from __future__ import annotations
import os
from celery import Celery

CELERY_BROKER_URL = os.getenv("CELERY_BROKER_URL", "redis://redis:6379/0")
CELERY_RESULT_BACKEND = os.getenv("CELERY_RESULT_BACKEND", "redis://redis:6379/0")

celery_app = Celery("hazardmapqc", broker=CELERY_BROKER_URL, backend=CELERY_RESULT_BACKEND)

def enqueue_process_media(media_id: str):
    celery_app.send_task("worker.process_media", args=[media_id])
