from __future__ import annotations

# Québec rule tags are represented as short identifiers you can expand in UI.
# Replace with exact CSTC/RSST section mapping table as you maintain it.
QC_RULES = {
  "FALL_UNPROTECTED_EDGE": ["QC:CSTC:FALL_PROTECTION"],
  "PPE_NO_HARDHAT": ["QC:CSTC:PPE_HEAD_PROTECTION"],
  "HOUSEKEEPING_TRIP": ["QC:CSTC:HOUSEKEEPING"],
  "WINTER_SNOW_ON_WALKWAY": ["QC:RSST:WINTER_CONDITIONS", "QC:CSTC:HOUSEKEEPING"],
  "WINTER_ICE_SUSPECTED": ["QC:RSST:WINTER_CONDITIONS"],
}

def hazard_from_signal(signal: str):
    # Return (hazard_type, title, severity)
    if signal == "WINTER_SNOW_ON_WALKWAY":
        return ("WINTER", "Snow on walking surface", "HIGH")
    if signal == "WINTER_ICE_SUSPECTED":
        return ("WINTER", "Ice suspected (conditions)", "MEDIUM")
    if signal == "PPE_NO_HARDHAT":
        return ("PPE", "Missing hard hat", "HIGH")
    if signal == "HOUSEKEEPING_TRIP":
        return ("HOUSEKEEPING", "Trip hazard in walkway", "MEDIUM")
    if signal == "FALL_UNPROTECTED_EDGE":
        return ("FALL", "Unprotected edge/opening", "CRITICAL")
    return ("GENERAL", signal, "LOW")

def rule_tags_for(signal: str):
    return QC_RULES.get(signal, ["QC:GENERAL"])
